<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link rel="stylesheet" href="/assets/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="/assets/css/MuseoSansW01-900.css">
    <link rel="stylesheet" href="/assets/fonts/font-awesome.min.css">
    <link rel="stylesheet" href="/assets/fonts/ionicons.min.css">
    <link rel="stylesheet" href="/assets/css/Footer-Basic.css">
    <link rel="stylesheet" href="/assets/css/Footer-Clean.css">
    <link rel="stylesheet" href="/assets/css/Footer-Dark.css">
    <link rel="stylesheet" href="/assets/css/Navigation-with-Search.css">
    <link rel="stylesheet" href="/assets/css/styles.css">
    <title>Hello, world!</title>
</head>
<body>
@include('navbar')


<div class="row container my-3 mx-3">
    <div class="col-12">
        <div class="row mx-2 mt-3">
            <div class="col-12 col-md-6 my-2 col-lg-4">
                <div class="card">
                    <div class="card-header">
                        Online Users
                    </div>
                    <div class="card-body">
                        <h4>{{(new \App\Models\Session())->activeSession()->has('data')->count()}}</h4>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="col-12">
        <table class="table table-sm">
            <thead>
            <tr>
                <th scope="col">Session Id</th>
                <th scope="col">Status</th>
                <th scope="col">IP</th>
                <th scope="col">Platform</th>
                <th scope="col">Country</th>
                <th scope="col">Take Control</th>
                <th scope="col">Mark Completed</th>
                <th scope="col">Created At</th>
            </tr>
            </thead>
            <tbody>
            @foreach($sessions as $session)
                @php
                    $data = json_decode($session->session_data);
                    if($session->hasSessionProcesses()){
                        $time = $session->sessionProcesses()->latest()->first()->created_at;
                    }else{
                        $time = $session->created_at;
                    }
                    if((bool)$session->data()->count()){
                        $dataTime = $session->data()->latest()->first()->created_at;
                    }
                    if(isset($dataTime)){
                        if(\Carbon\Carbon::parse($dataTime)->greaterThan($time)){
                            $time = $dataTime;
                        }
                    }
                    $isOnline =\App\Http\Controllers\Controller::isOnline($time);
                    $color = $isOnline?"success":"danger";
                    $text =  $isOnline?"Online":"Offline";
                @endphp
                <tr>
                    <th scope="row">{{$session->identifier}}</th>
                    <td><span class="badge badge-{{$color}}"><i class="fa fa-dot-circle"></i> {{$text}}</span></td>
                    <td>{{$data->ip}}</td>
                    <td>{{$data->user_agent}}</td>
                    <td>{{$data->country}}</td>
                    <td><a target="_blank" class="btn btn-info" href="{{route('show',['session'=>$session->identifier,'token'=>config('app.admin_token')])}}"><i class="fa fa-eye"></i></a></td>
                    <td><a target="_blank" class="btn btn-success" href="{{route('markCompleted',['identifier'=>$session->identifier])}}"><i class="fa fa-check"></i></a></td>
                    <td>{{$session->created_at}}</td>
                </tr>
            @endforeach

            </tbody>
        </table>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.3.1.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
<script>
    var iscomplete=true;
    setInterval(function (){
        if(iscomplete) {
            iscomplete = false;
            $.get('{{url()->current()}}', {}, function (data) {
                data = $(data);
                iscomplete=true;
                let container = $(data.filter('.container')[0]).html();
                console.log(container);
                $('.container').html(container);
            }).fail(function (){
                iscomplete=true;
            });
        }
    },3000)

</script>
</body>
</html>
